#install.packages("zoom")
#install.packages("olsrr")
#install.packages("boot")
#install.packages ("car")
#install.packages ("gtsummary")
library(boot)
library(zoom)
library(olsrr)
library (car)
library (gtsummary)

#install.packages("jtools")
library(jtools)
library(boot.pval)

#install.packages("sandwich")
#install.packages("lmtest")
library(sandwich)
library(lmtest)

# Load dataset
Positive_Messaging_dataset_cleaned <- read.csv("Positive_Messaging dataset_cleaned.csv")

# Make experimental conditions factors for regression model
Positive_Messaging_dataset_cleaned$Experimental_condition <- factor(Positive_Messaging_dataset_cleaned$experimental_con)
# physical health is 1, blank is 2, mental health is 3
####reorder factor so that blank is the reference group (then repeat everything with physical as reference)
Positive_Messaging_dataset_cleaned$Experimental_condition <- relevel(Positive_Messaging_dataset_cleaned$Experimental_condition, ref = "2")

#### primary question ####
##### regression model for primary analysis, with condition, and adjustment for pre MTSS all included. Post MTSS as outcome.
modelone <- lm(post_motivation_to_stop ~ pre_motivation_to_stop + Experimental_condition, data=Positive_Messaging_dataset_cleaned)

# regression output 
summary(modelone)
#run for SE
summ(modelone, confint = TRUE, digits = 2)
# run for CI

#check assumptions
#regression plots
plot (modelone, 1)
plot (modelone, 2)
plot (modelone, 3)
plot (modelone, 4)
plot(modelone)
# Are results affected by multi-collinearity - Variance Inflation Factor exploring multi-collinearity 
vif(modelone)
# eigen values to explore multi-collinearity 
ols_eigen_cindex(modelone)
bptest(modelone)

#### secondary question 1 - mental health status ####

modeltwo <- lm(post_motivation_to_stop ~ pre_motivation_to_stop + Experimental_condition + mental_health_status + Experimental_condition*mental_health_status, data=Positive_Messaging_dataset_cleaned)
# regression output 
summary(modeltwo) 
#run for SE
summ(modeltwo, confint = TRUE, digits = 2)
# run for CI

plot (modeltwo, 1)
plot (modeltwo, 2)
plot (modeltwo, 3)
plot (modeltwo, 4)
plot(modeltwo)
# Are results affected by multi-collinearity - Variance Inflation Factor exploring multi-collinearity 
vif(modeltwo)
# eigen values to explore multi-collinearity 
ols_eigen_cindex(modeltwo)
bptest(modeltwo)

#### secondary research question 1 - additionally controlling for FTND ####

modeltwosense <- lm(post_motivation_to_stop ~ pre_motivation_to_stop + Experimental_condition + mental_health_status + Experimental_condition*mental_health_status + FTND_total, data=Positive_Messaging_dataset_cleaned)
summary(modeltwosense) 
#run for SE
summ(modeltwosense, confint = TRUE, digits = 2)
plot(modeltwosense)
# Are results affected by multi-collinearity - Variance Inflation Factor exploring multi-collinearity 
vif(modeltwosense)
# eigen values to explore multi-collinearity 
ols_eigen_cindex(modeltwosense)
bptest(modeltwosense)

#### secondary question 2 - anhedonia ####

modelthree <- lm(post_motivation_to_stop ~ pre_motivation_to_stop + Experimental_condition + SHAPS_total + Experimental_condition*SHAPS_total, data=Positive_Messaging_dataset_cleaned)
# regression output 
summary(modelthree) 
#run for SE
summ(modelthree, confint = TRUE, digits = 2)
# run for CI

plot (modelthree, 1)
plot (modelthree, 2)
plot (modelthree, 3)
plot (modelthree, 4)
plot(modelthree)

#### add centered shaps
# Are results affected by multi-collinearity (plots suggest so) Variance Inflation Factor exploring multi-collinearity 
vif(modelthree)
# eigen values to explore multi-collinearity (is present)
ols_eigen_cindex(modelthree)
bptest(modelthree)

#recentre the continuous variable to assist with multi-collinearity (SHAPS)
Positive_Messaging_dataset_cleaned$SHAPScentred <- scale(Positive_Messaging_dataset_cleaned$SHAPS_total, scale=FALSE)
#rerun model three with centred shaps
modelthree <- lm(post_motivation_to_stop ~ pre_motivation_to_stop + Experimental_condition + SHAPScentred + Experimental_condition*SHAPScentred, data=Positive_Messaging_dataset_cleaned)
# regression output 
summary(modelthree) 
#run for SE
summ(modelthree, confint = TRUE, digits = 2)
# run for CI
plot(modelthree)
vif(modelthree) #VIF has reduced, no affect on results 


#### checking assumptions, issues with normality in all, so bootstrap 
#### boot strapping ####
#creating a bootstrapping function to pass to linear model
bootreg <- function(formula, data, i){
  d <- data[i, ]
  fit <- lm(formula, data=d)
  return(coef(fit))
}

#bootstrap analysis 2000 
#### primary question bootstrapped 
modeloneboot <- boot(statistic = bootreg, formula = post_motivation_to_stop ~ pre_motivation_to_stop + Experimental_condition, data=Positive_Messaging_dataset_cleaned, R=2000)
summary(modeloneboot)
boot.ci(modeloneboot, type="perc", index = 2)
boot.ci(modeloneboot, type="perc", index = 3)
boot.ci(modeloneboot, type="perc", index = 4)
#plot(modeloneboot)
#install.packages("boot.pval")
#library(boot.pval)
boot.pval(modeloneboot, type ="perc", theta_null = 0, pval_precision = NULL, index = 2)
boot.pval(modeloneboot, type ="perc", theta_null = 0, pval_precision = NULL, index = 3)
boot.pval(modeloneboot, type ="perc", theta_null = 0, pval_precision = NULL, index = 4)


#### secondary question 1 bootstrapped 
modeltwoboot <- boot(statistic = bootreg, formula = post_motivation_to_stop ~ pre_motivation_to_stop + Experimental_condition + mental_health_status + Experimental_condition*mental_health_status, data=Positive_Messaging_dataset_cleaned, R=2000)
summary(modeltwoboot)
boot.ci(modeltwoboot, type="perc", index = 2)
boot.ci(modeltwoboot, type="perc", index = 3)
boot.ci(modeltwoboot, type="perc", index = 4)
boot.ci(modeltwoboot, type="perc", index = 5)
boot.ci(modeltwoboot, type="perc", index = 6)
boot.ci(modeltwoboot, type="perc", index = 7)

boot.pval(modeltwoboot, type = "perc", theta_null = 0, pval_precision = NULL, index = 2)
boot.pval(modeltwoboot, type = "perc", theta_null = 0, pval_precision = NULL, index = 3)
boot.pval(modeltwoboot, type = "perc", theta_null = 0, pval_precision = NULL, index = 4)
boot.pval(modeltwoboot, type = "perc", theta_null = 0, pval_precision = NULL, index = 5)
boot.pval(modeltwoboot, type = "perc", theta_null = 0, pval_precision = NULL, index = 6)
boot.pval(modeltwoboot, type = "perc", theta_null = 0, pval_precision = NULL, index = 7)

#### secondary question 1 sensitivity bootstrapped 
modeltwosenseboot <- boot(statistic = bootreg, formula = post_motivation_to_stop ~ pre_motivation_to_stop + Experimental_condition + mental_health_status + Experimental_condition*mental_health_status + FTND_total, data=Positive_Messaging_dataset_cleaned, R=2000)
summary(modeltwosenseboot)
boot.ci(modeltwosenseboot, type="perc", index = 2)
boot.ci(modeltwosenseboot, type="perc", index = 3)
boot.ci(modeltwosenseboot, type="perc", index = 4)
boot.ci(modeltwosenseboot, type="perc", index = 5)
boot.ci(modeltwosenseboot, type="perc", index = 6)
boot.ci(modeltwosenseboot, type="perc", index = 7)
boot.ci(modeltwosenseboot, type="perc", index = 8)
### NOTE THAT 6 is FTND before mh interactions

boot.pval(modeltwosenseboot, type = "perc", theta_null = 0, pval_precision = NULL, index = 2)
boot.pval(modeltwosenseboot, type = "perc", theta_null = 0, pval_precision = NULL, index = 3)
boot.pval(modeltwosenseboot, type = "perc", theta_null = 0, pval_precision = NULL, index = 4)
boot.pval(modeltwosenseboot, type = "perc", theta_null = 0, pval_precision = NULL, index = 5)
boot.pval(modeltwosenseboot, type = "perc", theta_null = 0, pval_precision = NULL, index = 6)
boot.pval(modeltwosenseboot, type = "perc", theta_null = 0, pval_precision = NULL, index = 7)
boot.pval(modeltwosenseboot, type = "perc", theta_null = 0, pval_precision = NULL, index = 8)

### secondary question 2 bootstrapped
modelthreeboot <- boot(statistic = bootreg, formula = post_motivation_to_stop ~ pre_motivation_to_stop + Experimental_condition + SHAPScentred + Experimental_condition*SHAPScentred, data=Positive_Messaging_dataset_cleaned, R=2000)
summary(modelthreeboot)
boot.ci(modelthreeboot, type="perc", index = 2)
boot.ci(modelthreeboot, type="perc", index = 3)
boot.ci(modelthreeboot, type="perc", index = 4)
boot.ci(modelthreeboot, type="perc", index = 5)
boot.ci(modelthreeboot, type="perc", index = 6)
boot.ci(modelthreeboot, type="perc", index = 7)

boot.pval(modelthreeboot, type = "perc", theta_null = 0, pval_precision = NULL, index = 2)
boot.pval(modelthreeboot, type = "perc", theta_null = 0, pval_precision = NULL, index = 3)
boot.pval(modelthreeboot, type = "perc", theta_null = 0, pval_precision = NULL, index = 4)
boot.pval(modelthreeboot, type = "perc", theta_null = 0, pval_precision = NULL, index = 5)
boot.pval(modelthreeboot, type = "perc", theta_null = 0, pval_precision = NULL, index = 6)
boot.pval(modelthreeboot, type = "perc", theta_null = 0, pval_precision = NULL, index = 7)


#######Secondary outcome variables ####

#### intention to quit, adjusted for pre-intention to quit ####
intention_quit <- lm(post_plan_to_stop ~ pre_plan_to_quit + Experimental_condition, data = Positive_Messaging_dataset_cleaned)
summary(intention_quit)
summ(intention_quit, confint = TRUE, digits = 2)
# run for CI

plot (intention_quit, 1)
plot (intention_quit, 2)
plot (intention_quit, 3)
plot (intention_quit, 4)
plot(intention_quit)
vif(intention_quit)
bptest(intention_quit)

#bootstrap analysis 2000 
intention_quit_boot <- boot(statistic = bootreg, formula = post_plan_to_stop ~ pre_plan_to_quit + Experimental_condition, data = Positive_Messaging_dataset_cleaned, R=2000)
summary(intention_quit_boot)
boot.ci(intention_quit_boot, type="perc", index = 2)
boot.ci(intention_quit_boot, type="perc", index = 3)
boot.ci(intention_quit_boot, type="perc", index = 4)
boot.pval(intention_quit_boot, type = "perc", theta_null = 0, pval_precision = NULL, index = 2)
boot.pval(intention_quit_boot, type = "perc", theta_null = 0, pval_precision = NULL, index = 3)
boot.pval(intention_quit_boot, type = "perc", theta_null = 0, pval_precision = NULL, index = 4)


#### quitting self efficacy , adjusted for pre-quitting self efficacy ####
quitting_self_efficacy <- lm(post_quit__self_efficacy ~ pre_quit_self_efficacy + Experimental_condition, data = Positive_Messaging_dataset_cleaned)
summary (quitting_self_efficacy)
plot(quitting_self_efficacy)
vif(quitting_self_efficacy)
bptest(quitting_self_efficacy)

quitting_self_efficacy_boot <- boot(statistic = bootreg, formula = post_quit__self_efficacy ~ pre_quit_self_efficacy + Experimental_condition, data = Positive_Messaging_dataset_cleaned, R=2000)
summary(quitting_self_efficacy_boot)
boot.ci(quitting_self_efficacy_boot, type="perc", index = 2)
boot.ci(quitting_self_efficacy_boot, type="perc", index = 3)
boot.ci(quitting_self_efficacy_boot, type="perc", index = 4)
boot.pval(quitting_self_efficacy_boot, type = "perc", theta_null = 0, pval_precision = NULL, index = 2)
boot.pval(quitting_self_efficacy_boot, type = "perc", theta_null = 0, pval_precision = NULL, index = 3)
boot.pval(quitting_self_efficacy_boot, type = "perc", theta_null = 0, pval_precision = NULL, index = 4)


#### smoking beliefs, adjusted for pre smoking beliefs.####
beliefs <- lm(post_smoking_beliefs ~ pre_smoking_beliefs + Experimental_condition, data = Positive_Messaging_dataset_cleaned)
summary (beliefs)
plot(beliefs)
vif(beliefs)
bptest(beliefs)

beliefs_boot <- boot(statistic = bootreg, formula = post_smoking_beliefs ~ pre_smoking_beliefs + Experimental_condition, data = Positive_Messaging_dataset_cleaned, R=2000)
summary(beliefs_boot)
boot.ci(beliefs_boot, type="perc", index = 2)
boot.ci(beliefs_boot, type="perc", index = 3)
boot.ci(beliefs_boot, type="perc", index = 4)
boot.pval(beliefs_boot, type = "perc", theta_null = 0, pval_precision = NULL, index = 2)
boot.pval(beliefs_boot, type = "perc", theta_null = 0, pval_precision = NULL, index = 3)
boot.pval(beliefs_boot, type = "perc", theta_null = 0, pval_precision = NULL, index = 4)


#### attention ####
attention <- lm(Attention ~ Experimental_condition, data = Positive_Messaging_dataset_cleaned)
summary (attention)
plot(attention)
#heteroskedasticity present and slight violations of normality
bptest(attention)

#bootstrap 
attention_boot <- boot(statistic = bootreg, formula = Attention ~ Experimental_condition, data = Positive_Messaging_dataset_cleaned, R=2000)
summary(attention_boot)
boot.ci(attention_boot, type="perc", index = 2)
boot.ci(attention_boot, type="perc", index = 3)
boot.pval(attention_boot, type = "perc", theta_null = 0, pval_precision = NULL, index = 2)
boot.pval(attention_boot, type = "perc", theta_null = 0, pval_precision = NULL, index = 3)

#calcualte robust SE and CI due to model violations of heteroscedasticity
robust_se_attention <- coeftest(attention, vcov = vcovHC(attention, type = "HC3"))
print(robust_se_attention)
confint(robust_se_attention)
#conclusions are not different to bootstrapped model



####pleasant (valence) ####
pleasantreg <- lm(pleasant ~ Experimental_condition, data = Positive_Messaging_dataset_cleaned)
summary (pleasantreg)
plot(pleasantreg)
bptest(pleasantreg)
#heteroscedasticity present

pleasant_boot <- boot(statistic = bootreg, formula = pleasant ~ Experimental_condition, data = Positive_Messaging_dataset_cleaned, R=2000)
summary(pleasant_boot)
boot.ci(pleasant_boot, type="perc", index = 2)
boot.ci(pleasant_boot, type="perc", index = 3)
boot.pval(pleasant_boot, type = "perc", theta_null = 0, pval_precision = NULL, index = 2)
boot.pval(pleasant_boot, type = "perc", theta_null = 0, pval_precision = NULL, index = 3)

#calcualte robust SE and CI due to model violations of heteroscedasticity
robust_se_pleasant <- coeftest(pleasantreg, vcov = vcovHC(pleasantreg, type = "HC3"))
print(robust_se_pleasant)
confint(robust_se_pleasant)
#conclusions are not different to bootstrapped model


#### arousal ####
arousalreg <- lm (arousal ~ Experimental_condition, data = Positive_Messaging_dataset_cleaned)
summary (arousalreg)
plot(arousalreg)
bptest(arousalreg)
#no heterscedasticity

arousal_boot <- boot(statistic = bootreg, formula = arousal ~ Experimental_condition, data = Positive_Messaging_dataset_cleaned, R=2000)
summary(arousal_boot)
boot.ci(arousal_boot, type="perc", index = 2)
boot.ci(arousal_boot, type="perc", index = 3)
boot.pval(arousal_boot, type = "perc", theta_null = 0, pval_precision = NULL, index = 2)
boot.pval(arousal_boot, type = "perc", theta_null = 0, pval_precision = NULL, index = 3)


#### dominance ####
dominancereg <- lm(dominance ~ Experimental_condition, data = Positive_Messaging_dataset_cleaned)
summary (dominancereg)
plot(dominancereg)
bptest(dominancereg)
#heteroscedasticity present

dominance_boot <- boot(statistic = bootreg, formula = dominance ~ Experimental_condition, data = Positive_Messaging_dataset_cleaned, R=2000)
summary(dominance_boot)
boot.ci(dominance_boot, type="perc", index = 2)
boot.ci(dominance_boot, type="perc", index = 3)
boot.pval(dominance_boot, type = "perc", theta_null = 0, pval_precision = NULL, index = 2)
boot.pval(dominance_boot, type = "perc", theta_null = 0, pval_precision = NULL, index = 3)

#calcualte robust SE and CI due to model violations of heteroscedasticity
robust_se_dominance <- coeftest(dominancereg, vcov = vcovHC(dominancereg, type = "HC3"))
print(robust_se_dominance)
confint(robust_se_dominance)
#conclusions are not different to bootstrapped model

####believability ####
believability <- lm (belief ~ Experimental_condition, data = Positive_Messaging_dataset_cleaned)
summary (believability)
plot(believability)
bptest(believability)
#heteroscedasticity present
#violation of normality

believability_boot <- boot(statistic = bootreg, formula = belief ~ Experimental_condition, data = Positive_Messaging_dataset_cleaned, R=2000)
summary(believability_boot)
boot.ci(believability_boot, type="perc", index = 2)
boot.ci(believability_boot, type="perc", index = 3)
boot.pval(believability_boot, type = "perc", theta_null = 0, pval_precision = NULL, index = 2)
boot.pval(believability_boot, type = "perc", theta_null = 0, pval_precision = NULL, index = 3)

#calcualte robust SE and CI due to model violations of heteroscedasticity
robust_se_believability <- coeftest(believability, vcov = vcovHC(believability, type = "HC3"))
print(robust_se_believability)
confint(robust_se_believability)
#conclusions are not different to bootstrapped model


#### MEANS 
#pre and post MTSS data collapsed across MH status data by condition
Physical_pre <- mean(subset(Positive_Messaging_dataset_cleaned, experimental_con == 1) $pre_motivation_to_stop)
Blank_pre <- mean(subset(Positive_Messaging_dataset_cleaned, experimental_con == 2) $pre_motivation_to_stop)
Mental_pre <- mean(subset(Positive_Messaging_dataset_cleaned, experimental_con == 3) $pre_motivation_to_stop)
Physical_post <- mean(subset(Positive_Messaging_dataset_cleaned, experimental_con == 1) $post_motivation_to_stop, na.rm=T)
Blank_post <- mean(subset(Positive_Messaging_dataset_cleaned, experimental_con == 2) $post_motivation_to_stop, na.rm=T)
Mental_post <- mean(subset(Positive_Messaging_dataset_cleaned, experimental_con == 3) $post_motivation_to_stop, na.rm=T)

#standard deviations for above means 
Physical_pre_sd <- sd (subset(Positive_Messaging_dataset_cleaned, experimental_con == 1) $pre_motivation_to_stop)
Blank_pre_sd <- sd (subset(Positive_Messaging_dataset_cleaned, experimental_con == 2) $pre_motivation_to_stop)
Mental_pre_sd <- sd (subset(Positive_Messaging_dataset_cleaned, experimental_con == 3) $pre_motivation_to_stop)
Physical_post_sd <- sd (subset(Positive_Messaging_dataset_cleaned, experimental_con == 1) $post_motivation_to_stop, na.rm=T)
Blank_post_sd <- sd (subset(Positive_Messaging_dataset_cleaned, experimental_con == 2) $post_motivation_to_stop, na.rm=T)
Mental_post_sd <- sd (subset(Positive_Messaging_dataset_cleaned, experimental_con == 3) $post_motivation_to_stop, na.rm=T)
